<x-filament-panels::page>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        
        @php
            // Define a cleaner, more muted color scheme
            $card_colors = [
                'requests' => ['main' => 'sky', 'light' => 'sky-100', 'text' => 'sky-600'],
                'words' => ['main' => 'emerald', 'light' => 'emerald-100', 'text' => 'emerald-600'],
                'credits' => ['main' => 'amber', 'light' => 'amber-100', 'text' => 'amber-600'],
                'cost' => ['main' => 'red', 'light' => 'red-100', 'text' => 'red-600'],
            ];
        @endphp

        <div class="bg-white rounded-xl shadow-md border border-gray-100 p-6 transition hover:shadow-lg">
            <div class="flex items-start justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-500">Total AI Requests</p>
                    <p class="text-4xl font-extrabold text-{{ $card_colors['requests']['text'] }} mt-2">{{ $this->totalRequests }}</p>
                    <p class="text-xs text-gray-400 mt-1">All time usage</p>
                </div>
                <div class="bg-{{ $card_colors['requests']['light'] }} p-3 rounded-xl">
                    <x-heroicon-o-chat-bubble-left-ellipsis class="w-8 h-8 text-{{ $card_colors['requests']['text'] }}" />
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md border border-gray-100 p-6 transition hover:shadow-lg">
            <div class="flex items-start justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-500">Words Generated</p>
                    <p class="text-4xl font-extrabold text-{{ $card_colors['words']['text'] }} mt-2">{{ $this->totalWords }}</p>
                    <p class="text-xs text-gray-400 mt-1">Total content</p>
                </div>
                <div class="bg-{{ $card_colors['words']['light'] }} p-3 rounded-xl">
                    <x-heroicon-o-document-text class="w-8 h-8 text-{{ $card_colors['words']['text'] }}" />
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md border border-gray-100 p-6 transition hover:shadow-lg">
            <div class="flex items-start justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-500">Free Credits Used</p>
                    <p class="text-4xl font-extrabold text-{{ $card_colors['credits']['text'] }} mt-2">{{ $this->freeCreditsUsed }}</p>
                    <p class="text-xs text-gray-400 mt-1">Credit usage</p>
                </div>
                <div class="bg-{{ $card_colors['credits']['light'] }} p-3 rounded-xl">
                    <x-heroicon-o-gift class="w-8 h-8 text-{{ $card_colors['credits']['text'] }}" />
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md border border-gray-100 p-6 transition hover:shadow-lg">
            <div class="flex items-start justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-500">Total Cost</p>
                    <p class="text-4xl font-extrabold text-{{ $card_colors['cost']['text'] }} mt-2">{{ $this->totalCost }}</p>
                    <p class="text-xs text-gray-400 mt-1">Estimated value</p>
                </div>
                <div class="bg-{{ $card_colors['cost']['light'] }} p-3 rounded-xl">
                    <x-heroicon-o-currency-rupee class="w-8 h-8 text-{{ $card_colors['cost']['text'] }}" />
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        
        <div class="lg:col-span-2 space-y-8">
            
            <div class="bg-white rounded-xl shadow-md border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-100">
                    <h2 class="text-xl font-bold text-gray-800 flex items-center gap-2">
                        <x-heroicon-o-chart-bar class="w-6 h-6 text-cyan-600" />
                        Daily Usage Trend
                    </h2>
                    <p class="text-sm text-gray-500 mt-1">Activity over the last 30 days</p>
                </div>
                <div class="p-6">
                    <div class="space-y-3 max-h-96 overflow-y-auto pr-2">
                        @php
                            $maxWords = $this->getDailyUsageTrend()->max('words');
                        @endphp

                        @foreach($this->getDailyUsageTrend() as $trend)
                            <div class="border-b border-gray-100 pb-3 last:border-b-0 hover:bg-gray-50 transition-colors p-2 -mx-2 rounded-lg">
                                <div class="flex justify-between items-center mb-1">
                                    <span class="font-semibold text-gray-700 text-sm">{{ \Carbon\Carbon::parse($trend->date)->format('M d, Y') }}</span>
                                    <span class="text-xs bg-cyan-50 text-cyan-700 px-2 py-0.5 rounded-full font-medium">
                                        {{ $trend->requests }} requests
                                    </span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center gap-2">
                                        <span class="text-sm text-gray-500">Words generated:</span>
                                    </div>
                                    <span class="font-bold text-emerald-600 text-sm">{{ number_format($trend->words) }}</span>
                                </div>
                                <div class="mt-2 w-full bg-gray-100 rounded-full h-1.5">
                                    <div class="bg-cyan-500 h-1.5 rounded-full transition-all duration-500" 
                                         style="width: {{ ($trend->words / max($maxWords, 1)) * 100 }}%">
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-md border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-100">
                    <h2 class="text-xl font-bold text-gray-800 flex items-center gap-2">
                        <x-heroicon-o-clock class="w-6 h-6 text-indigo-600" />
                        Peak Usage Hours
                    </h2>
                    <p class="text-sm text-gray-500 mt-1">When AI is most actively used</p>
                </div>
                <div class="p-6">
                    <div class="space-y-4">
                        @php
                            $maxRequests = $this->getUsageByHour()->max('requests');
                        @endphp
                        @foreach($this->getUsageByHour() as $hourUsage)
                            <div class="flex items-center justify-between">
                                <span class="text-sm font-semibold text-gray-700 w-24">
                                    {{ str_pad($hourUsage->hour, 2, '0', STR_PAD_LEFT) }}:00
                                </span>
                                <div class="flex items-center gap-3 flex-grow ml-4">
                                    <div class="w-full bg-gray-200 rounded-full h-2">
                                        <div class="bg-indigo-500 h-2 rounded-full transition-all duration-500" 
                                             style="width: {{ ($hourUsage->requests / max($maxRequests, 1)) * 100 }}%">
                                        </div>
                                    </div>
                                    <span class="text-sm font-bold text-indigo-600 w-10 text-right">
                                        {{ number_format($hourUsage->requests) }}
                                    </span>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>


        <div class="lg:col-span-1 space-y-8">
            
            <div class="bg-white rounded-xl shadow-md border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-100">
                    <h2 class="text-xl font-bold text-gray-800 flex items-center gap-2">
                        <x-heroicon-o-information-circle class="w-6 h-6 text-gray-600" />
                        Quick Metrics
                    </h2>
                    <p class="text-sm text-gray-500 mt-1">Key performance indicators</p>
                </div>
                <div class="p-6">
                    <div class="space-y-4">
                        <div class="flex items-center justify-between pb-3 border-b border-gray-100">
                            <div class="flex items-center gap-3">
                                <x-heroicon-o-arrow-trending-up class="w-6 h-6 text-sky-500" />
                                <p class="text-sm text-gray-600 font-medium">Avg. Words/Request</p>
                            </div>
                            <p class="text-2xl font-bold text-sky-600">{{ $this->avgWordsPerRequest }}</p>
                        </div>
                        <div class="flex items-center justify-between pb-3 border-b border-gray-100">
                            <div class="flex items-center gap-3">
                                <x-heroicon-o-calendar class="w-6 h-6 text-emerald-500" />
                                <p class="text-sm text-gray-600 font-medium">Today's Requests</p>
                            </div>
                            <p class="text-2xl font-bold text-emerald-600">{{ $this->todaysRequests }}</p>
                        </div>
                        <div class="flex items-center justify-between pb-3 border-b border-gray-100">
                            <div class="flex items-center gap-3">
                                <x-heroicon-o-currency-rupee class="w-6 h-6 text-fuchsia-500" />
                                <p class="text-sm text-gray-600 font-medium">Avg. Cost/Request</p>
                            </div>
                            <p class="text-2xl font-bold text-fuchsia-600">{{ $this->avgCostPerRequest }}</p>
                        </div>
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <x-heroicon-o-user-group class="w-6 h-6 text-orange-500" />
                                <p class="text-sm text-gray-600 font-medium">Total Agents</p>
                            </div>
                            <p class="text-2xl font-bold text-orange-600">{{ $this->totalAgents }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-md border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-100">
                    <h2 class="text-xl font-bold text-gray-800 flex items-center gap-2">
                        <x-heroicon-o-user-group class="w-6 h-6 text-purple-600" />
                        Top Agents
                    </h2>
                    <p class="text-sm text-gray-500 mt-1">Highest word count generated</p>
                </div>
                <div class="p-6">
                    <div class="space-y-3">
                        @foreach($this->getTopAgentsByUsage() as $index => $usage)
                            <div class="flex items-center justify-between p-3 border-b border-gray-100 last:border-b-0 hover:bg-gray-50 transition-colors rounded-lg -mx-3">
                                <div class="flex items-center gap-4">
                                    <div class="flex items-center justify-center w-6 h-6 bg-purple-100 text-purple-600 rounded-md text-xs font-bold shrink-0">
                                        {{ $index + 1 }}
                                    </div>
                                    <div>
                                        <p class="font-medium text-gray-800 text-sm">{{ $usage->travelAgent->name ?? 'Unknown Agent' }}</p>
                                        <p class="text-xs text-gray-400 mt-0.5 truncate">{{ $usage->travelAgent->email ?? 'No email' }}</p>
                                    </div>
                                </div>
                                <div class="text-right shrink-0 ml-4">
                                    <p class="font-bold text-purple-600 text-sm">{{ number_format($usage->total_words) }}</p>
                                    <p class="text-xs text-gray-500 mt-0.5">words</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

        </div>
    </div>
</x-filament-panels::page>