<!DOCTYPE html>
<html>
<head>
    <title>{{ $subject ?? 'Email from Travel Agency' }}</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { 
            font-family: Arial, sans-serif; 
            line-height: 1.6; 
            color: #333; 
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 8px 8px 0 0;
            margin: -30px -30px 20px -30px;
        }
        .content {
            min-height: 200px;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            font-size: 14px;
            color: #666;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Travel Agency Notification</h1>
        </div>
        
        <div class="content">
            {!! $content ?? $htmlContent ?? '<p>No content provided</p>' !!}
        </div>
        
        <div class="footer">
            <p><strong>Travel Agent ID:</strong> {{ $travelAgentId ?? 'N/A' }}</p>
            <p>Sent on: {{ now()->format('F j, Y \a\t g:i A') }}</p>
            <p>Best regards,<br>Travel Agency Team</p>
        </div>
    </div>
</body>
</html>