<?php

namespace Database\Seeders;

use App\Models\SuperAdmin;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class SuperAdminSeeder extends Seeder
{
    public function run()
    {
        SuperAdmin::create([
            'name' => 'TripCup Super Admin',
            'email' => 'superadmin@tripcup.com',
            'password' => Hash::make('SuperAdmin@2024!'),
            'is_active' => true,
            'email_verified_at' => now(),
        ]);

        // Optional backup admin
        SuperAdmin::create([
            'name' => 'Backup Super Admin',
            'email' => 'backup@tripcup.com',
            'password' => Hash::make('BackupAdmin@2024!'),
            'is_active' => true,
            'email_verified_at' => now(),
        ]);
    }
}