<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class SubscriptionPlansSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'plan_name' => 'Basic Plan',
                'monthly_words' => 2000,
                'carry_forward_months' => 3,
                'top_up_rate' => 0.12,
                'price' => 249.00,
                'words_remaining' => 2000,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'plan_name' => 'Pro Plan',
                'monthly_words' => 5000,
                'carry_forward_months' => 6,
                'top_up_rate' => 0.10,
                'price' => 499.00,
                'words_remaining' => 5000,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'plan_name' => 'Enterprise Plan',
                'monthly_words' => 12000,
                'carry_forward_months' => 12,
                'top_up_rate' => 0.08,
                'price' => 999.00,
                'words_remaining' => 12000,
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ];

        DB::table('ai_subscriptions')->insert($plans);
        
        $this->command->info('Subscription plans seeded successfully!');
        $this->command->info('Basic Plan: 2,000 words/month, ₹249, 3-month carry forward');
        $this->command->info('Pro Plan: 5,000 words/month, ₹499, 6-month carry forward');
        $this->command->info('Enterprise Plan: 12,000 words/month, ₹999, 12-month carry forward');
    }
}
