<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SeasonalCacheSeeder extends Seeder
{
    public function run()
    {
        $dates = [
            // Peak season dates (15-20% hike)
            ['2025-10-15', 1.15, 'peak', 'Diwali season'],
            ['2025-10-16', 1.15, 'peak', 'Diwali season'],
            ['2025-12-20', 1.20, 'peak', 'Christmas/New Year'],
            ['2025-12-25', 1.20, 'peak', 'Christmas'],
            
            // Shoulder season dates (5-10% hike)
            ['2025-11-01', 1.10, 'shoulder', 'Post-Diwali'],
            ['2025-11-15', 1.05, 'shoulder', 'Winter onset'],
            
            // Off-season dates (no hike)
            ['2025-09-01', 1.00, 'off', 'Monsoon season'],
            ['2025-06-15', 1.00, 'off', 'Low season'],
        ];

        foreach ($dates as $date) {
            DB::table('seasonal_caches')->insert([
                'date' => $date[0],
                'multiplier' => $date[1],
                'season_type' => $date[2],
                'description' => $date[3],
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}