<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Hotel;

class HotelSeeder extends Seeder
{
    public function run(): void
    {
        Hotel::create([
            'travel_agent_id' => 1,
            'name' => 'Viceroy Hotel',
            'room_variations' => [
                ['type' => 'Standard', 'price' => 3000],
                ['type' => 'Luxury', 'price' => 5000]
            ],
            'extra_bed_price' => 500
        ]);

        Hotel::create([
            'travel_agent_id' => 1,
            'name' => 'Darjeeling Residency',
            'room_variations' => [
                ['type' => 'Standard', 'price' => 2500],
                ['type' => 'Luxury', 'price' => 4000]
            ],
            'extra_bed_price' => 400
        ]);
    }
}
