<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AiPlansSeeder extends Seeder
{
    public function run(): void
    {
        $plans = [
            [
                'name' => 'free',
                'display_name' => 'Free Plan',
                'monthly_words' => 0, // Free plan doesn't have subscription words
                'carry_forward_months' => 0,
                'top_up_rate' => 0.15, // Default top-up rate for free users
                'price' => 0.00,
                'free_words_included' => 500,
                'description' => 'Perfect for small agencies starting with AI',
                'features' => json_encode([
                    '500 free words every month',
                    'No credit card required',
                    'Basic AI generation',
                    'Pay-as-you-go top-ups'
                ]),
                'is_active' => true,
                'sort_order' => 0,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'basic',
                'display_name' => 'Basic Plan',
                'monthly_words' => 2000,
                'carry_forward_months' => 3,
                'top_up_rate' => 0.12,
                'price' => 249.00,
                'free_words_included' => 500,
                'description' => 'Best for growing travel businesses',
                'features' => json_encode([
                    '2,000 subscription words monthly',
                    '+ 500 free words monthly',
                    '3-month carry forward',
                    '₹0.12/word top-up rate',
                    'Priority support'
                ]),
                'is_active' => true,
                'sort_order' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'pro',
                'display_name' => 'Pro Plan', 
                'monthly_words' => 5000,
                'carry_forward_months' => 6,
                'top_up_rate' => 0.10,
                'price' => 499.00,
                'free_words_included' => 500,
                'description' => 'For established travel agencies',
                'features' => json_encode([
                    '5,000 subscription words monthly',
                    '+ 500 free words monthly', 
                    '6-month carry forward',
                    '₹0.10/word top-up rate',
                    'Priority support',
                    'Advanced analytics'
                ]),
                'is_active' => true,
                'sort_order' => 2,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'enterprise',
                'display_name' => 'Enterprise Plan',
                'monthly_words' => 12000,
                'carry_forward_months' => 12,
                'top_up_rate' => 0.08,
                'price' => 999.00,
                'free_words_included' => 500,
                'description' => 'For high-volume travel businesses',
                'features' => json_encode([
                    '12,000 subscription words monthly',
                    '+ 500 free words monthly',
                    '12-month carry forward', 
                    '₹0.08/word top-up rate',
                    '24/7 priority support',
                    'Advanced analytics',
                    'Custom AI training'
                ]),
                'is_active' => true,
                'sort_order' => 3,
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ];

        DB::table('ai_plans')->insert($plans);
        
        $this->command->info('AI Plans seeded successfully!');
        $this->command->info('✓ Free Plan: 500 free words/month');
        $this->command->info('✓ Basic Plan: 2,500 total words/month, ₹249');
        $this->command->info('✓ Pro Plan: 5,500 total words/month, ₹499'); 
        $this->command->info('✓ Enterprise Plan: 12,500 total words/month, ₹999');
    }
}