<?php
// database/migrations/2025_01_01_000000_create_seasonal_calendars_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('seasonal_calendars', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // 'High Session', 'Puja Session', etc.
            $table->text('description')->nullable();
            $table->date('start_date');
            $table->date('end_date');
            $table->decimal('price_increase_percentage', 5, 2); // 25.00, 10.00, etc.
            $table->enum('session_type', ['regular', 'special'])->default('regular');
            $table->string('color_code')->default('#FF6B6B'); // For UI
            $table->boolean('recurring_yearly')->default(true);
            $table->boolean('is_active')->default(true);
            $table->integer('priority')->default(1); // For conflict resolution
            $table->timestamps();

            // Indexes for performance
            $table->index(['start_date', 'end_date']);
            $table->index(['is_active', 'session_type']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('seasonal_calendars');
    }
};