<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::table('invoices', function (Blueprint $table) {
            $table->enum('status', ['Pending', 'Finalized', 'Cancelled'])->default('Pending')->change();
            $table->text('cancellation_reason')->nullable();
            $table->timestamp('cancelled_at')->nullable();
            $table->decimal('refund_amount', 10, 2)->default(0.00);
            $table->enum('refund_status', ['Pending', 'Processed', 'Rejected'])->default('Pending');
            $table->text('refund_notes')->nullable();
        });
    }

    public function down() {
        Schema::table('invoices', function (Blueprint $table) {
            $table->enum('status', ['Pending', 'Finalized'])->default('Pending')->change();
            $table->dropColumn(['cancellation_reason', 'cancelled_at', 'refund_amount', 'refund_status', 'refund_notes']);
        });
    }
};