<?php
// database/migrations/2025_09_21_000002_create_ai_subscriptions_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAiSubscriptionsTable extends Migration
{
    public function up()
    {
        Schema::create('ai_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('travel_agent_id')->constrained()->onDelete('cascade');
            $table->string('plan_name');
            $table->integer('credits');
            $table->decimal('price', 8, 2);
            $table->integer('credits_used')->default(0);
            $table->timestamp('start_date')->nullable(); // Changed to nullable
            $table->timestamp('end_date')->nullable();   // Changed to nullable
            $table->string('payment_status')->default('pending');
            $table->string('payment_id')->nullable();
            $table->timestamps();
            
            $table->index('travel_agent_id');
            $table->index('payment_status');
        });
    }

    public function down()
    {
        Schema::dropIfExists('ai_subscriptions');
    }
}