<?php
// database/migrations/2025_09_21_000000_create_ai_keys_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAiKeysTable extends Migration
{
    public function up()
    {
        Schema::create('ai_keys', function (Blueprint $table) {
            $table->id();
            $table->foreignId('travel_agent_id')->constrained()->onDelete('cascade');
            $table->string('gemini_api_key')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('free_credits_used')->default(0);
            $table->integer('paid_credits_used')->default(0);
            $table->integer('total_credits_used')->default(0);
            $table->timestamp('subscription_start_date')->nullable(); // Made nullable
            $table->timestamp('subscription_end_date')->nullable();   // Made nullable
            $table->timestamps();
            
            $table->unique('travel_agent_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('ai_keys');
    }
}