<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('day_descriptions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('travel_agent_id');
            $table->string('daydescription_title');
            $table->text('daydescription_description');
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('travel_agent_id')
                  ->references('id')
                  ->on('travel_agents')
                  ->onDelete('cascade');
            
            // Index for better performance
            $table->index('travel_agent_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('day_descriptions');
    }
};