<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('travel_agents', function (Blueprint $table) {
            // General Company/Agent Information
            $table->string('gst_number')->nullable()->after('contact_info');
            $table->text('address')->nullable()->after('gst_number');
            $table->string('logo_file')->nullable()->after('address');
            $table->string('contact_person_name')->nullable()->after('name');
            
            // Content Fields for Invoices
            $table->longText('terms_and_conditions')->nullable();
            $table->longText('cancellation_policy')->nullable();
            $table->json('inclusions')->nullable();
            $table->json('exclusions')->nullable();

            // API Credentials for multi-tenant setup
            $table->string('mail_mailer')->nullable();
            $table->string('mail_host')->nullable();
            $table->integer('mail_port')->nullable();
            $table->string('mail_username')->nullable();
            $table->string('mail_password')->nullable();
            $table->string('mail_from_address')->nullable();
            $table->string('mail_from_name')->nullable();
            $table->string('sms_sid')->nullable();
            $table->string('sms_token')->nullable();
            $table->string('sms_from_number')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('travel_agents', function (Blueprint $table) {
            $table->dropColumn([
                'gst_number',
                'address',
                'logo_file',
                'contact_person_name',
                'terms_and_conditions',
                'cancellation_policy',
                'inclusions',
                'exclusions',
                'mail_mailer',
                'mail_host',
                'mail_port',
                'mail_username',
                'mail_password',
                'mail_from_address',
                'mail_from_name',
                'sms_sid',
                'sms_token',
                'sms_from_number',
            ]);
        });
    }
};