<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->decimal('billed_amount', 12, 2)->default(0)->after('margin_percentage');
            $table->decimal('margin_amount', 12, 2)->default(0)->after('billed_amount');
            $table->decimal('tax_amount', 12, 2)->default(0)->after('margin_amount');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropColumn(['billed_amount', 'margin_amount', 'tax_amount']);
        });
    }
};
