<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('invoice_days', function (Blueprint $table) {
            $table->integer('day_number')->after('invoice_id');
            $table->date('day_date')->after('day_number');
        });
    }

    public function down(): void
    {
        Schema::table('invoice_days', function (Blueprint $table) {
            $table->dropColumn(['day_number', 'day_date']);
        });
    }
};

