<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->unsignedBigInteger('travel_agent_id')->nullable()->after('id');
            $table->string('mobile')->nullable()->after('email');
            $table->string('pin_code')->nullable()->after('password');
            $table->timestamp('access_expires_at')->nullable()->after('pin_code');
            $table->timestamp('last_login_at')->nullable()->after('access_expires_at');
            $table->string('last_login_method')->nullable()->after('last_login_at');
            $table->string('otp')->nullable()->after('last_login_method');
            $table->timestamp('otp_expires_at')->nullable()->after('otp');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'travel_agent_id',
                'mobile',
                'pin_code',
                'access_expires_at',
                'last_login_at',
                'last_login_method',
                'otp',
                'otp_expires_at'
            ]);
        });
    }
};

