<?php

return [
    'defaults' => [
        'guard' => env('AUTH_GUARD', 'web'),
        'passwords' => env('AUTH_PASSWORD_BROKER', 'users'),
    ],

    'guards' => [
        'web' => [
            'driver' => 'session',
            'provider' => 'users',
        ],
        
        'api' => [
            'driver' => 'sanctum',
            'provider' => 'users',
        ],
        
        'superadmin' => [ // Filament will use this guard
            'driver' => 'session',
            'provider' => 'superadmin_users',
        ],
        
        'superadmin-api' => [
            'driver' => 'sanctum',
            'provider' => 'superadmins',
        ],
    ],

    'providers' => [
        'users' => [
            'driver' => 'eloquent',
            'model' => env('AUTH_MODEL', App\Models\User::class),
        ],
        
        'superadmins' => [
            'driver' => 'eloquent',
            'model' => App\Models\SuperAdmin::class,
        ],
        
        'superadmin_users' => [ // Filament will use this provider
            'driver' => 'eloquent',
            'model' => App\Models\SuperAdminUser::class,
        ],
    ],

    'passwords' => [
        'users' => [
            'provider' => 'users',
            'table' => env('AUTH_PASSWORD_RESET_TOKEN_TABLE', 'password_reset_tokens'),
            'expire' => 60,
            'throttle' => 60,
        ],
        
        'superadmins' => [
            'provider' => 'superadmins',
            'table' => 'super_admin_password_reset_tokens',
            'expire' => 60,
            'throttle' => 60,
        ],
        
        'superadmin_users' => [
            'provider' => 'superadmin_users',
            'table' => 'super_admin_user_password_reset_tokens',
            'expire' => 60,
            'throttle' => 60,
        ],
    ],

    'password_timeout' => env('AUTH_PASSWORD_TIMEOUT', 10800),
];