<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        // Register your custom middleware aliases here.
        // This allows you to use 'admin.check' instead of the full class path in your routes.
        $middleware->alias([
            'admin.check' => \App\Http\Middleware\AdminCheck::class,
            'superadmin' => \App\Http\Middleware\SuperAdminCheck::class, // ADD THIS LINE
        ]);

        // You can also add global middleware or update existing groups here if needed.
        // Example for API group (optional, Laravel usually handles this):
        // $middleware->api(prepend: [
        //     \Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful::class,
        // ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();