<?php
namespace App\Services;

use App\Models\AiPlan;
use App\Models\AiSubscription;
use App\Models\TravelAgent;

class SubscriptionService
{
    // Get all active plans for display
    public function getAvailablePlans()
    {
        return AiPlan::where('is_active', true)
                    ->orderBy('sort_order')
                    ->get();
    }

    // Get current plan for travel agent
    public function getCurrentPlan($travelAgentId)
    {
        $subscription = AiSubscription::where('travel_agent_id', $travelAgentId)
            ->where('status', 'active')
            ->with('plan')
            ->first();

        // If no active subscription, return free plan
        if (!$subscription) {
            return AiPlan::where('name', 'free')->first();
        }

        return $subscription->plan;
    }

    // Check if travel agent has active subscription
    public function hasActiveSubscription($travelAgentId)
    {
        return AiSubscription::where('travel_agent_id', $travelAgentId)
            ->where('status', 'active')
            ->where('end_date', '>', now())
            ->exists();
    }

    // Get subscription words remaining
    public function getRemainingWords($travelAgentId)
    {
        $subscription = AiSubscription::where('travel_agent_id', $travelAgentId)
            ->where('status', 'active')
            ->first();

        return $subscription ? $subscription->words_remaining : 0;
    }
}