<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TripPayment extends Model
{
    use HasFactory;

    protected $table = 'trip_payments';

    protected $fillable = [
        'invoice_id',
        'type',
        'amount',
        'payment_method',
        'transaction_id',
        'reference_number',
        'payment_date',
        'notes',
        'status'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'payment_date' => 'date',
    ];

    // Relationships
    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    // Scopes
    public function scopeCompleted($query)
    {
        return $query->where('status', 'Completed');
    }

    public function scopeRefunds($query)
    {
        return $query->where('type', 'Refund');
    }

    public function scopeSuccessfulPayments($query)
    {
        return $query->where('type', '!=', 'Refund')->where('status', 'Completed');
    }

    public function scopeAdvances($query)
    {
        return $query->where('type', 'Advance');
    }

    public function scopeInstallments($query)
    {
        return $query->where('type', 'Installment');
    }
}