<?php
// app/Models/SeasonalCache.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SeasonalCache extends Model
{
    use HasFactory;

    // EXPLICITLY set the table name
    protected $table = 'seasonal_cache';

    protected $fillable = [
        'date',
        'total_hike_percentage',
        'applicable_sessions',
        'cache_year'
    ];

    protected $casts = [
        'date' => 'date',
        'total_hike_percentage' => 'decimal:2',
        'applicable_sessions' => 'array'
    ];

    // Find cached value for date
    public static function getCachedMultiplier($date)
    {
        return static::where('date', $date->format('Y-m-d'))->first();
    }

    // Cache a value for date
    public static function cacheMultiplier($date, $totalHike, $sessions)
    {
        return static::updateOrCreate(
            ['date' => $date->format('Y-m-d')],
            [
                'total_hike_percentage' => $totalHike,
                'applicable_sessions' => $sessions,
                'cache_year' => $date->year
            ]
        );
    }
}