<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceDayService extends Model
{
    use HasFactory;

    protected $fillable = ['invoice_day_id', 'service_id', 'variation', 'qty', 'unit_price'];

    public function invoiceDay()
    {
        return $this->belongsTo(InvoiceDay::class);
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }
}

