<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceDayHotel extends Model
{
    use HasFactory;

    protected $fillable = [
    'invoice_day_id',
    'hotel_id',
    'room_type',
    'extra_bed',
    'qty',         // Make sure this is included
    'price',
    // other fields
    ];

    public function invoiceDay()
    {
        return $this->belongsTo(InvoiceDay::class);
    }

    public function hotel()
    {
        return $this->belongsTo(Hotel::class);
    }
}

