<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Hotel extends Model
{
    use HasFactory;

    protected $fillable = ['travel_agent_id', 'name', 'room_variations', 'extra_bed_price'];

    protected $casts = [
        'room_variations' => 'array',
    ];

    public function travelAgent()
    {
        return $this->belongsTo(TravelAgent::class);
    }
}

