<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DayDescription extends Model
{
    use HasFactory;

    protected $fillable = [
        'travel_agent_id',
        'daydescription_title',
        'daydescription_description'
    ];

    /**
     * Get the travel agent that owns the day description.
     */
    public function travelAgent(): BelongsTo
    {
        return $this->belongsTo(TravelAgent::class);
    }

     // Add this new relationship for invoice days with correct table name
    public function invoiceDays()
    {
        return $this->belongsToMany(InvoiceDay::class, 'invoice_day_descriptions');
    }
}   