<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;

    protected $fillable = ['travel_agent_id', 'name', 'address', 'mobile', 'whatsapp', 'email'];

    public function travelAgent()
    {
        return $this->belongsTo(TravelAgent::class);
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }
}

