<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;

    // Use the travel_agents table
    protected $table = 'travel_agents';

    // Update with all the new fields from the migration
    protected $fillable = [
        'name',
        'email',
        'phone',
        'contact_info',
        'rules_and_regulations',
        
        // --- ADDED FIELDS ---
        'contact_person_name',
        'gst_number',
        'address',
        'logo_file',
        'terms_and_conditions',
        'cancellation_policy',
        'inclusions',
        'exclusions',
        'mail_mailer',
        'mail_host',
        'mail_port',
        'mail_username',
        'mail_password',
        'mail_from_address',
        'mail_from_name',
        'sms_sid',
        'sms_token',
        'sms_from_number',
    ];
    
    // Optional: Define relationships if needed
    public function services()
    {
        return $this->hasMany(Service::class, 'travel_agent_id');
    }

    public function hotels()
    {
        return $this->hasMany(Hotel::class, 'travel_agent_id');
    }

    public function extraServices()
    {
        return $this->hasMany(ExtraService::class, 'travel_agent_id');
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class, 'travel_agent_id');
    }
}