<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AiPlan extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'display_name',
        'monthly_words',
        'carry_forward_months',
        'top_up_rate',
        'price',
        'description',
        'free_words_included',
        'is_active',
        'sort_order',
        'features'
    ];

    protected $casts = [
        'features' => 'array',
        'price' => 'decimal:2',
        'top_up_rate' => 'decimal:3',
        'is_active' => 'boolean',
        'monthly_words' => 'integer',
        'carry_forward_months' => 'integer',
        'free_words_included' => 'integer'
    ];

    // Relationship with subscriptions
    public function subscriptions()
    {
        return $this->hasMany(AiSubscription::class);
    }

    // Get total words including free words
    public function getTotalWordsAttribute()
    {
        return $this->monthly_words + $this->free_words_included;
    }

    // Check if this is free plan
    public function isFree()
    {
        return $this->name === 'free';
    }
}