<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SuperAdminCheck
{
    public function handle(Request $request, Closure $next)
    {
        // Check if user is authenticated and is a SuperAdmin instance
        if (!$request->user() || !($request->user() instanceof \App\Models\SuperAdmin)) {
            return response()->json([
                'message' => 'SuperAdmin access required',
                'error' => 'FORBIDDEN'
            ], 403);
        }
        
        return $next($request);
    }
}