<?php

namespace App\Http\Controllers;

use App\Models\MailConfig;
use Illuminate\Http\Request;

class MailConfigController extends Controller
{
    public function storeOrUpdate(Request $request)
    {
        $request->validate([
            'travel_agent_id' => 'required|exists:travel_agents,id',
            'host' => 'required',
            'port' => 'required|integer',
            'username' => 'required',
            'password' => 'required',
            'from_address' => 'required|email',
            'from_name' => 'required',
        ]);

        $config = MailConfig::updateOrCreate(
            ['travel_agent_id' => $request->travel_agent_id],
            $request->all()
        );

        return response()->json([
            'message' => 'Mail configuration saved successfully',
            'data' => $config
        ]);
    }

    public function show($travel_agent_id)
    {
        $config = MailConfig::where('travel_agent_id', $travel_agent_id)->first();

        if (!$config) {
            return response()->json([
                'message' => 'Mail configuration not found'
            ], 404);
        }

        return response()->json([
            'data' => $config
        ]);
    }
}