<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Company;

class CompanyController extends Controller
{
    // Make sure this uses auth:sanctum middleware in api.php
    public function show($id)
    {
        $company = Company::find($id);

        if (!$company) {
            return response()->json(['message' => 'Company not found'], 404);
        }

        return response()->json([
            'id' => $company->id,
            'name' => $company->name,
            'contact_person_name' => $company->contact_person_name, // New
            'email' => $company->email,
            'phone' => $company->phone,
            'contact_info' => $company->contact_info,
            'gst_number' => $company->gst_number, // New
            'address' => $company->address, // New
            'logo_file' => $company->logo_file, // New
            'rules_and_regulations' => $company->rules_and_regulations,
            'terms_and_conditions' => $company->terms_and_conditions, // New
            'cancellation_policy' => $company->cancellation_policy, // New
            'inclusions' => $company->inclusions, // New
            'exclusions' => $company->exclusions, // New
        ], 200);
    }
}