<?php

namespace App\Filament\Widgets;

use App\Models\TravelAgent;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Database\Eloquent\Builder;

class TopTravelAgents extends BaseWidget
{
    protected static ?string $heading = 'Top Travel Agents by Users';
    
    protected int | string | array $columnSpan = 'half';
    protected static ?int $sort = 5;

    public function table(Table $table): Table
    {
        return $table
            ->query(
                TravelAgent::withCount(['users', 'invoices', 'aiSubscriptions'])
                    ->orderBy('users_count', 'desc')
            )
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->searchable()
                    ->sortable(),
                    
                Tables\Columns\TextColumn::make('users_count')
                    ->label('Users')
                    ->sortable()
                    ->alignCenter(),
                    
                Tables\Columns\TextColumn::make('invoices_count')
                    ->label('Invoices')
                    ->sortable()
                    ->alignCenter(),
                    
                Tables\Columns\TextColumn::make('aiSubscriptions_count')
                    ->label('Subscriptions')
                    ->sortable()
                    ->alignCenter(),
                    
                Tables\Columns\IconColumn::make('is_active')
                    ->label('Active')
                    ->boolean()
                    ->sortable(),
            ])
            ->paginated(false);
    }
}