<?php

namespace App\Filament\Widgets;

use App\Models\Payment;
use Filament\Widgets\ChartWidget;
use Illuminate\Support\Carbon;

class RevenueChart extends ChartWidget
{
    protected ?string $heading = 'Monthly Revenue';
    
    protected ?string $maxHeight = '300px';
    protected static ?int $sort = 7;

    protected function getData(): array
    {
        $monthlyData = [];
        $labels = [];

        for ($month = 1; $month <= 12; $month++) {
            $startOfMonth = now()->setMonth($month)->startOfMonth();
            $endOfMonth = now()->setMonth($month)->endOfMonth();

            $total = Payment::whereBetween('created_at', [$startOfMonth, $endOfMonth])
                ->sum('amount');

            $monthlyData[] = $total;
            $labels[] = $startOfMonth->format('M');
        }

        return [
            'datasets' => [
                [
                    'label' => 'Revenue (₹)',
                    'data' => $monthlyData,
                    'backgroundColor' => 'rgba(59, 130, 246, 0.2)',
                    'borderColor' => 'rgb(59, 130, 246)',
                    'borderWidth' => 2,
                    'fill' => true,
                ],
            ],
            'labels' => $labels,
        ];
    }

    protected function getType(): string
    {
        return 'line';
    }
}