<?php

namespace App\Filament\Widgets;

use App\Models\Payment;
use Filament\Widgets\ChartWidget;

class RevenueByTypeChart extends ChartWidget
{
    protected ?string $heading = 'Revenue by Payment Type';
    
    protected ?string $maxHeight = '300px';
    protected static ?int $sort = 2;

    protected function getData(): array
    {
        $data = Payment::where('status', 'captured')
            ->selectRaw('entity_type, SUM(amount) as total')
            ->groupBy('entity_type')
            ->get();

        return [
            'datasets' => [
                [
                    'label' => 'Revenue by Type',
                    'data' => $data->pluck('total')->toArray(),
                    'backgroundColor' => [
                        'rgb(59, 130, 246)', // Blue for subscriptions
                        'rgb(34, 197, 94)',  // Green for top-ups
                    ],
                ],
            ],
            'labels' => $data->map(fn ($item) => match($item->entity_type) {
                'plan' => 'Subscriptions',
                'top_up' => 'Top-ups',
                default => ucfirst($item->entity_type)
            })->toArray(),
        ];
    }

    protected function getType(): string
    {
        return 'pie';
    }
}