<?php

namespace App\Filament\Resources\PaymentAnalytics\Pages;

use App\Filament\Resources\PaymentAnalytics\PaymentAnalyticsResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;

class ListPaymentAnalytics extends ListRecords
{
    protected static string $resource = PaymentAnalyticsResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('paymentSummary')
                ->label('Payment Summary')
                ->icon('heroicon-o-chart-bar')
                ->url(route('filament.superadmin.pages.payment-summary'))
                ->color('info'),
                
            Actions\ExportAction::make()
                ->label('Export Payments')
                ->icon('heroicon-o-arrow-down-tray'),
        ];
    }
}