<?php
namespace App\Filament\Resources\AiUsageAnalytics\Pages;

use App\Filament\Resources\AiUsageAnalytics\AiUsageAnalyticsResource;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;

class ViewAiUsageAnalytics extends ViewRecord
{
    protected static string $resource = AiUsageAnalyticsResource::class;

    public function infolist(\Filament\Schemas\Schema $schema): \Filament\Schemas\Schema
    {
        return $schema
            ->schema([
                \Filament\Schemas\Components\Section::make('AI Usage Details')
                    ->schema([
                        \Filament\Schemas\Components\Grid::make(2)
                            ->schema([
                                \Filament\Schemas\Components\Text::make('Travel Agent:'),
                                \Filament\Schemas\Components\Text::make('travelAgent.name')
                                    ->content(fn ($record) => $record->travelAgent->name ?? 'N/A'),
                            ]),
                        \Filament\Schemas\Components\Grid::make(2)
                            ->schema([
                                \Filament\Schemas\Components\Text::make('Request Title:'),
                                \Filament\Schemas\Components\Text::make('title')
                                    ->content(fn ($record) => $record->title),
                            ]),
                        \Filament\Schemas\Components\Text::make('Prompt Used:'),
                        \Filament\Schemas\Components\Text::make('prompt_used')
                            ->columnSpanFull()
                            ->content(fn ($record) => nl2br(e($record->prompt_used))),
                    ]),

                \Filament\Schemas\Components\Section::make('Usage Metrics')
                    ->schema([
                        \Filament\Schemas\Components\Grid::make(2)
                            ->schema([
                                \Filament\Schemas\Components\Text::make('Words Generated:'),
                                \Filament\Schemas\Components\Text::make('word_count')
                                    ->content(fn ($record) => $record->word_count)
                                    ->badge()
                                    ->color('success'),
                            ]),
                        \Filament\Schemas\Components\Grid::make(2)
                            ->schema([
                                \Filament\Schemas\Components\Text::make('Credit Type:'),
                                \Filament\Schemas\Components\Text::make('used_free_credit')
                                    ->content(fn ($record) => $record->used_free_credit ? 'Free Credit' : 'Paid Credit')
                                    ->badge()
                                    ->color(fn ($record) => $record->used_free_credit ? 'warning' : 'primary'),
                            ]),
                        \Filament\Schemas\Components\Grid::make(2)
                            ->schema([
                                \Filament\Schemas\Components\Text::make('Cost:'),
                                \Filament\Schemas\Components\Text::make('cost')
                                    ->content(fn ($record) => '₹' . number_format($record->cost, 2))
                                    ->badge()
                                    ->color('danger'),
                            ]),
                        \Filament\Schemas\Components\Grid::make(2)
                            ->schema([
                                \Filament\Schemas\Components\Text::make('Request Time:'),
                                \Filament\Schemas\Components\Text::make('created_at')
                                    ->content(fn ($record) => $record->created_at->format('M j, Y g:i A')),
                            ]),
                    ]),
            ]);
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make(),
            Actions\DeleteAction::make(),
            Actions\Action::make('back')
                ->label('Back to List')
                ->url(static::$resource::getUrl('index'))
                ->color('gray'),
        ];
    }
}